/*
 * QrfeReaderManager.h
 *
 *  Created on: 27.01.2009
 *      Author: stefan.detter
 */

#ifndef CQRFEREADERMANAGER_H_
#define CQRFEREADERMANAGER_H_

#include <QObject>
#include <QMap>
#include <QVariant>

#include <QrfeTraceModule>

#include "QrfeReaderInterfaceGlobal.h"
#include "QrfeReaderInterface.h"

#ifdef QRFE_DEVICEDETECTOR
	#include <QrfeDeviceDetector>
#endif

#ifdef QRFE_SERIALPORT
	#include <QrfeSerialPort>
#endif

#ifdef QRFE_BONJOUR
	#include <QrfeBonjourServiceBrowser>
#endif

typedef struct {
	QrfeGlobal::DeviceType 	type;
	QString 				humanReadableName;
	QString 				path;
	QVariant 				data;
} QrfeReaderDeviceInformation;
Q_DECLARE_METATYPE(QrfeReaderDeviceInformation)

class QrfeReaderManager : public QObject, QrfeTraceModule
{
	Q_OBJECT
public:
	QrfeReaderManager(QObject* parent = 0);
	virtual ~QrfeReaderManager();

	typedef enum{
		OK,
		ERROR_PORT,
		ERROR_PROTOCOLL,
		ERROR_DOUBLE_ID
	} Result;

#ifdef QRFE_SERIALPORT
	typedef enum{
		SERIAL_BAUD_115200 = 0,
		SERIAL_BAUD_57600 = 1,
		SERIAL_BAUD_38400 = 2,
		SERIAL_BAUD_19200 = 3,
		SERIAL_BAUD_9600 = 4,
	} SerialBaud;
#endif

public slots:
	Result addReader(QrfeReaderDeviceInformation devInfo);

	Result addReader(QrfeGlobal::DeviceType type, QString deviceName);

	Result addReader(QIODevice* dev, QrfeGlobal::DeviceType type);

#ifdef QRFE_SERIALPORT
	Result addSerialReader(QString port);
	Result addSerialReader(QString port, SerialBaud baudrate, bool hwFlowControl);
#endif

#ifdef QRFE_HIDDEVICE
	Result addHidReader(QString path);
#endif

#ifdef QT_NETWORK_LIB
	Result addTcpReader(QString ip);
#endif

#ifdef QRFE_BONJOUR
	Result addBonjourReader(QrfeBonjourRecord rec);
#endif

	void cleanUp();

	void attachUsbReaderAutomatically(bool attachAutomatically);

	void checkForNewDevice();

public:
	QList<QString>			readerList() const;
	QrfeReaderInterface*	readerInterface(QString readerId) const;

public:
	QList<QrfeReaderDeviceInformation>	availablePortList();
	QList<QrfeReaderDeviceInformation>	availableHidList();
	QList<QrfeReaderDeviceInformation>	availableBonjourServices();

signals:
	void gotReader(QrfeReaderInterface* reader);
	void lostReader(QrfeReaderInterface* reader);

	void deviceListsChanged();
	void newReaderDeviceDetected ( const QrfeReaderDeviceInformation& devInf );

private slots:
	void lostConnectionToReader();
	void deleteRequest();

	void readerDestroyed(QObject* reader = 0);

#if (defined QRFE_DEVICEDETECTOR) && (defined QRFE_HIDDEVICE)
	void hidDeviceAttached ( QString devicePath, quint16 vendorID, quint16 productID );
#endif

	void processDeviceListsChanges();

private:
	void addReader(QrfeReaderInterface* reader);

private:
	QMap<QString, QrfeReaderInterface*>		m_readerIDs;
	QMap<QString, QrfeReaderInterface*>		m_toDelete;

	bool									m_aboutToDestroy;

	bool 									m_attachUsbReaderAutomatically;

#ifdef QRFE_SERIALPORT
    QMap<QString, QString>                  m_usedPorts;
#endif

#ifdef QRFE_BONJOUR
	QrfeBonjourServiceBrowser*		m_bonjourBrowser;
#endif

#ifdef QRFE_DEVICEDETECTOR
	QrfeDeviceDetector				m_deviceDetecor;
#endif

public:
	static uint 				_traceLevel;
	static uint 				_functionTraceLevel;
};

#endif /* CQRFEREADERMANAGER_H_ */
